<?php
// Iniciar sesión
session_start();

// Incluir la conexión a la base de datos
require_once 'conexiones/conexion.php';
require_once 'solicitudes/email_usuario_conectado.php';
// Obtener el rol y el email del usuario conectado
$role = $result['role'];
$email = $result['email'];

// Variable para almacenar el usuario seleccionado (solo para admin)
$usuario_seleccionado = $email;

// Si es admin, procesar selección de usuario
if ($role === 'admin' && isset($_POST['usuario'])) {
    $usuario_seleccionado = $_POST['usuario'];
}

// Consultar los datos del usuario seleccionado
$stmt = $pdo->prepare("SELECT COUNT(*) AS tickets_totales, SUM(precio) AS recaudado_total FROM tickets WHERE usuario_venta = ?");
$stmt->execute([$usuario_seleccionado]);
$datos_usuario = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener lista de usuarios (solo para admin)
$usuarios = [];
if ($role === 'admin') {
    $stmt = $pdo->query("SELECT email FROM usuarios");
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Caja de Usuarios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
       <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php 
    include "menuajuste.php";
     ?>
<div class="content">
    <h1 class="text-center">Caja de Usuarios</h1>
    
    <?php if ($role === 'admin'): ?>
        <form method="POST" class="mb-4">
            <label for="usuario" class="form-label">Seleccionar Usuario:</label>
            <select name="usuario" id="usuario" class="form-select" onchange="this.form.submit()">
                <?php foreach ($usuarios as $usuario): ?>
                    <option value="<?= $usuario['email'] ?>" <?= $usuario['email'] === $usuario_seleccionado ? 'selected' : '' ?>>
                        <?= $usuario['email'] ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </form>
    <?php else: ?>
        <p><strong>Usuario:</strong> <?= $email ?></p>
    <?php endif; ?>

    <h3>Información del Usuario</h3>
    <ul>
        <li><strong>Tickets Totales:</strong> <?= $datos_usuario['tickets_totales'] ?></li>
        <li><strong>Recaudado Total:</strong> <?= $datos_usuario['recaudado_total'] ?? 0 ?> USD</li>
    </ul>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
